import Foundation
import OtrnLibrary

func writeOTRNExampleSimple() {
    print("--- OTRN Write Example Start ---")
    print("Writing file at: \(filePath)\n")

    let sequenceNote1 = OtrnNote(
        time: 15.34,
        comment: "Camera shake detected. Needs stabilization.",
        timecode: "00:00:15:08",
        color: "red"
    )
    
    let sequenceNote2 = OtrnNote(
        time: 24.00,
        comment: "Lens flare.",
        timecode: "00:00:24:00",
        color: "blue"
    )
    
    let sequenceNote3 = OtrnNote(
        time: 29.00,
        comment: "Camera in frame",
        timecode: "00:00:29:00",
    )
    
    let sequence = OtrnSequence(
        name: "Main Edit V3",
        frameRate: 25.0,
        dropFrame: false,
        startTime: 0,
        startTimecode: "10:00:00:00",
        startFrame: 0,
        notes: [sequenceNote1,sequenceNote2,sequenceNote3]
    )
    
    let metadata = OtrnMetadata(
        project: "The Swift OTRN Project",
        software: "Swift OtrnLibrary Example",
        otrnVersion: 1,
        otrnInfo: "This is an OTRN (Open Timecode-Related Notes) notes file. Learn more about the specification on https://otrn.editingtools.io",
        timestamp: OtrnMetadata.defaultTimestamp
    )

    let documentToWrite = OtrnDocument(
        metadata: metadata,
        sequence: sequence
    )

    do {
        try documentToWrite.write(to: filePath)
        print("Successfully wrote OTRN document.")
    } catch {
        print("\nFATAL ERROR during Write: \(error)")
    }
}
